package com.example.androidtest20200107;

import java.util.List;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;

public class TestActivity2 extends Activity {

    private static final String TETHER_UPDATE_ACTION = "shmaker.action.intent.TETHER_UPDATE";
    private static final String TETHER_SSID_EXTRA = "SSID";
    private static final String SECURITY_TYPE_EXTRA = "security_type";
    private static final String TETHER_PASSWORD_EXTRA = "password";
    private static final String TETHER_BAND_EXTRA = "band_index";
    private static final String TETHER_OPEN_EXTRA = "open";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.main, menu);
        return true;
    }

    public void initLauncher() {
        String ORIGINAL_LAUNCHER_PACKAGENAME = "com.xxx.ilauncher";// 包名
        String ORIGINAL_LAUNCHER_CLASSNAME = "com.xxx.ilauncher.MainActivity"; // 类名
        Intent queryIntent = new Intent();
        final PackageManager mPm = this.getPackageManager();
        queryIntent.addCategory(Intent.CATEGORY_HOME);
        queryIntent.setAction(Intent.ACTION_MAIN);

        List<ResolveInfo> homeActivities = mPm.queryIntentActivities(queryIntent, 0);
        if (homeActivities == null) {
            return;
        }

        ComponentName defaultLauncher = new ComponentName(ORIGINAL_LAUNCHER_PACKAGENAME, ORIGINAL_LAUNCHER_CLASSNAME);
        int activityNum = homeActivities.size();
        ComponentName[] set = new ComponentName[activityNum];
        int defaultMatch = -1;
        for (int i = 0; i < activityNum; i++) {
            ResolveInfo info = homeActivities.get(i);
            set[i] = new ComponentName(info.activityInfo.packageName, info.activityInfo.name);
            if (ORIGINAL_LAUNCHER_CLASSNAME.equals(info.activityInfo.name)
                    && ORIGINAL_LAUNCHER_PACKAGENAME.equals(info.activityInfo.packageName)) {
                defaultMatch = info.match;
            }
        }

        // if Launcher is not found, do not set anything
        if (defaultMatch == -1) {
            return;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction(Intent.ACTION_MAIN);
        filter.addCategory(Intent.CATEGORY_HOME);
        filter.addCategory(Intent.CATEGORY_DEFAULT);

        mPm.addPreferredActivity(filter, defaultMatch, set, defaultLauncher);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
        Log.i("gaochong", "++++++++++++++++++++++++++");
        if (id == R.id.action_wifi) {
            Intent intent = new Intent(TETHER_UPDATE_ACTION);
            intent.setPackage("com.android.settings");
            intent.putExtra(TETHER_SSID_EXTRA, "aaaa");
            intent.putExtra(TETHER_OPEN_EXTRA, true);
            sendBroadcast(intent);
            return true;
        } else if (id == R.id.action_imei1) {
            Intent intent = new Intent(TETHER_UPDATE_ACTION);
            intent.setPackage("com.android.settings");
            intent.putExtra(TETHER_SSID_EXTRA, "bbbb");
            intent.putExtra(SECURITY_TYPE_EXTRA, 4);
            intent.putExtra(TETHER_PASSWORD_EXTRA, "bbbbbbbb");
            intent.putExtra(TETHER_OPEN_EXTRA, true);
            sendBroadcast(intent);
            return true;
        } else if (id == R.id.action_imei2) {
            Intent intent = new Intent(TETHER_UPDATE_ACTION);
            intent.setPackage("com.android.settings");
            intent.putExtra(TETHER_SSID_EXTRA, "aaaa");
            intent.putExtra(SECURITY_TYPE_EXTRA, 0);
            intent.putExtra(TETHER_PASSWORD_EXTRA, "aaaaaaaa");
            intent.putExtra(TETHER_OPEN_EXTRA, false);
            sendBroadcast(intent);
            return true;
        } else if (id == R.id.action_boot) {
            Intent intent = new Intent(TETHER_UPDATE_ACTION);
            intent.setPackage("com.android.settings");
            intent.putExtra(TETHER_SSID_EXTRA, "bbbb");
            intent.putExtra(TETHER_PASSWORD_EXTRA, "bbbb");
            intent.putExtra(TETHER_OPEN_EXTRA, true);
            sendBroadcast(intent);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

}