package com.nextbiometrics.biometrics.jna;

import com.nextbiometrics.system.jna.NBSizeType;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Structure.ByReference;
import java.util.Arrays;
import java.util.List;

public class NBBiometricsScanParamsData extends Structure {
    public int eScanFormat;
    public int iTimeout;
    public NBBiometricsScanPreviewCallback.NBBiometricsScanPreviewProc pPreviewProc;
    public NBSizeType pParam;

    public NBBiometricsScanParamsData() {
    }

    public NBBiometricsScanParamsData(Pointer p) {
        super(p);
        read();
    }

    protected List<String> getFieldOrder() {
        return Arrays.asList(new String[] { "eScanFormat", "iTimeout", "pPreviewProc", "pParam" });
    }

    public static class ByReference extends NBBiometricsScanParamsData implements Structure.ByReference {
        public ByReference() {
            this(null);
        }

        public ByReference(NBBiometricsScanParamsData value) {
            if (value != null) {
                this.eScanFormat = value.eScanFormat;
                this.iTimeout = value.iTimeout;
                this.pPreviewProc = value.pPreviewProc;
                this.pParam = value.pParam;
            }
        }
    }
}
