package com.nextbiometrics.biometrics;

import java.util.EnumSet;

public enum NBBiometricsStatus {
    /* 12 */ NONE(0),

    /* 16 */ OK(1),

    /* 20 */ TIMEOUT(2),

    /* 24 */ CANCELED(3),

    /* 28 */ BAD_QUALITY(4),

    /* 32 */ TOO_FEW_MINUTIAE(5),

    /* 36 */ MATCH_NOT_FOUND(6),

    /* 40 */ LATENT_DETECTED(7),

    /* 44 */ NEED_MORE_SAMPLES(8);

    private int value;

    private NBBiometricsStatus(int value) {
        /* 57 */ this.value = value;
    }

    public static final NBBiometricsStatus get(int value) {
        /* 65 */ for (NBBiometricsStatus v : EnumSet.allOf(NBBiometricsStatus.class)) {
            /* 66 */ if (value == v.getValue())
                /* 67 */ return v;
        }
        /* 69 */ throw new IllegalArgumentException("value is an unknown NBBiometricsStatus value");
    }

    public final int getValue() {
        /* 77 */ return this.value;
    }
}
