package com.nextbiometrics.biometrics.jna;

import com.nextbiometrics.system.jna.NBSizeType;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Structure.ByReference;
import java.util.Arrays;
import java.util.List;

public class NBBiometricsIdentifyResultDetailsData extends Structure {
    public NBSizeType pTemplateId;
    public int iIndex;
    public int iScore;

    public NBBiometricsIdentifyResultDetailsData() {
    }

    public NBBiometricsIdentifyResultDetailsData(Pointer p) {
        super(p);
        read();
    }

    protected List<String> getFieldOrder() {
        return Arrays.asList(new String[] { "pTemplateId", "iIndex", "iScore" });
    }

    public static class ByReference extends NBBiometricsIdentifyResultDetailsData implements Structure.ByReference {
        public ByReference() {
            this(null);
        }

        public ByReference(NBBiometricsIdentifyResultDetailsData value) {
            if (value != null) {
                this.pTemplateId = value.pTemplateId;
                this.iIndex = value.iIndex;
                this.iScore = value.iScore;
            }
        }
    }
}
