package com.nextbiometrics.devices;

import java.util.EnumSet;

public enum NBDeviceFingerDetectType {
    /* 12 */ BASELINE(0),

    /* 16 */ ENHANCED(1),

    /* 20 */ QUICK(2),

    /* 24 */ LAST_WAKE(3);

    private int value;

    private NBDeviceFingerDetectType(int value) {
        /* 37 */ this.value = value;
    }

    public static final NBDeviceFingerDetectType get(int value) {
        /* 45 */ for (NBDeviceFingerDetectType v : EnumSet.allOf(NBDeviceFingerDetectType.class)) {
            /* 46 */ if (value == v.getValue())
                /* 47 */ return v;
        }
        /* 49 */ throw new IllegalArgumentException("value is an unknown NBDeviceFingerDetectType value");
    }

    public final int getValue() {
        /* 57 */ return this.value;
    }
}
