package com.nextbiometrics.devices.jna;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Structure.ByReference;
import java.util.Arrays;
import java.util.List;

public class NBDeviceInfoExAData extends Structure {
    public byte[] szPath;
    public int iFileDescriptor;
    public int iVendorId;
    public int iProductId;

    public NBDeviceInfoExAData() {
        /* 38 */ this.szPath = new byte[256];
    }

    public NBDeviceInfoExAData(Pointer p) {
        /* 42 */ super(p);
        /* 43 */ this.szPath = new byte[256];
        /* 44 */ read();
    }

    public NBDeviceInfoExAData(String path, int fileDescriptor, int vendorId, int productId) {
        /* 48 */ this();
        /* 49 */ byte[] pathBytes = path.getBytes();
        /* 50 */ System.arraycopy(pathBytes, 0, this.szPath, 0, pathBytes.length);
        /* 51 */ this.iFileDescriptor = fileDescriptor;
        /* 52 */ this.iVendorId = vendorId;
        /* 53 */ this.iProductId = productId;
    }

    protected List<String> getFieldOrder() {
        /* 58 */ return Arrays.asList(new String[] { "szPath", "iFileDescriptor", "iVendorId", "iProductId" });
    }

    public static class ByReference extends NBDeviceInfoExAData implements Structure.ByReference {
        public ByReference() {
            /* 13 */ this(null);
        }

        public ByReference(NBDeviceInfoExAData value) {
            /* 18 */ if (value != null) {
                /* 19 */ this.szPath = value.szPath;
                /* 20 */ this.iFileDescriptor = value.iFileDescriptor;
                /* 21 */ this.iVendorId = value.iVendorId;
                /* 22 */ this.iProductId = value.iProductId;
            }
        }

        public ByReference(String path, int fileDescriptor, int vendorId, int productId) {
            /* 27 */ super(path, fileDescriptor, vendorId, productId);
        }
    }
}
