package android.scaner;

import android.os.RemoteException;

public class CmxxScanerManager {
    private final ICmxxScanerInterface mService;

    public CmxxScanerManager(ICmxxScanerInterface service) {
        mService = service;
    }

    public boolean openScaner() {
        try {
            return mService.openScaner();
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean closeScaner(boolean recall) {
        try {
            return mService.closeScaner(recall);
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean startScanning(boolean decode) {
        try {
            return mService.startScanning(decode);
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean stopScanning() {
        try {
            return mService.stopScanning();
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean isScanerOpened() {
        try {
            return mService.isScanerOpened();
        } catch (RemoteException e) {
        }
        return false;
    }

    public int getScanerState() {
        try {
            return mService.getScanerState();
        } catch (RemoteException e) {
        }
        return -1;
    }

    public boolean canRecall() {
        try {
            return mService.canRecall();
        } catch (RemoteException e) {
        }
        return false;
    }

    public boolean doGetScanningState() {
        try {
            return mService.doGetScanningState();
        } catch (RemoteException e) {
        }
        return false;
    }

    public int doSetSymbology(String paramNum, String paramVal, boolean init) {
        try {
            return mService.doSetSymbology(paramNum, paramVal, init);
        } catch (RemoteException e) {
        }
        return -1;
    }

    public int doSetSymbologyConfig(String paramNum, String config, String paramVal, boolean init) {
        try {
            return mService.doSetSymbologyConfig(paramNum, config, paramVal, init);
        } catch (RemoteException e) {
        }
        return -1;
    }

    public String doGetSymbology(String paramNum) {
        try {
            return mService.doGetSymbology(paramNum);
        } catch (RemoteException e) {
        }
        return null;
    }

    public String doGetSymbologyConfig(String paramNum, String config) {
        try {
            return mService.doGetSymbologyConfig(paramNum, config);
        } catch (RemoteException e) {
        }
        return null;
    }

    public int doDefaultParams() {
        try {
            return mService.doDefaultParams();
        } catch (RemoteException e) {
        }
        return -1;
    }

    public String doGetSDKVersion() {
        try {
            return mService.doGetSDKVersion();
        } catch (RemoteException e) {
        }
        return "";
    }

    public String doGetScannerVersion() {
        try {
            return mService.doGetScannerVersion();
        } catch (RemoteException e) {
        }
        return "";
    }

    public String doGetDecodeVersion() {
        try {
            return mService.doGetDecodeVersion();
        } catch (RemoteException e) {
        }
        return "";
    }

}
