package com.example.androidtest20200107;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;

public class TestActivity3 extends Activity {

    private static final String TAG = TestActivity3.class.getSimpleName();

    private static final String SYS_PATH = "/sys/devices/platform/pinctrl@10005000/gpiochip0/gpio/gpio337/value";

    private static final long BATTERY_LEVEL_CHANGE_THROTTLE_MS = 60 * 1000;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        read(SYS_PATH);
        write(SYS_PATH);
        read(SYS_PATH);
        Log.e("", "" + BATTERY_LEVEL_CHANGE_THROTTLE_MS);

        View view = null;
        view.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View arg0) {
                // TODO Auto-generated method stub

            }
        });
    }

    public static String read(String sys_path) {
        try {
            Log.w(TAG, "read data ---> ");
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("cat " + sys_path); // 此处进行读操作
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line;
            while (null != (line = br.readLine())) {
                Log.w(TAG, "read data ---> " + line);
                return line;
            }
        } catch (IOException e) {
            e.printStackTrace();
            Log.w(TAG, "*** ERROR *** Here is what I know: " + e.getMessage());
        }
        return null;
    }

    public static void write(String sys_path) {
        Process p = null;
        DataOutputStream os = null;
        try {
            Log.w(TAG, "write data ---> ");
            p = Runtime.getRuntime().exec("sh");
            os = new DataOutputStream(p.getOutputStream());
            os.writeBytes("echo 1 > " + sys_path + "\n");
            os.writeBytes("exit\n");
            os.flush();
        } catch (IOException e) {
            e.printStackTrace();
            Log.e(TAG, " can't write " + sys_path + e.getMessage());
        } finally {
            if (p != null) {
                p.destroy();
            }
            if (os != null) {
                try {
                    os.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

    }

}
