package com.nextbiometrics.biometrics;

import com.nextbiometrics.biometrics.jna.NBBiometricsTemplateTypeInfoData;
import com.nextbiometrics.system.jna.NBSizeType;

public final class NBBiometricsTemplateTypeInfo {
    private NBBiometricsTemplateType templateType;
    public boolean isExtractionSupported;
    public boolean isVerificationSupported;
    public boolean isIdentificationSupported;
    public boolean isConversionToSupported;
    public boolean isConversionFromSupported;
    public int maxTemplateSize;

    public NBBiometricsTemplateTypeInfo(NBBiometricsTemplateType templateType, boolean isExtractionSupported,
            boolean isVerificationSupported, boolean isIdentificationSupported, boolean isConversionToSupported,
            boolean isConversionFromSupported, int maxTemplateSize) {
        /* 28 */ this.templateType = templateType;
        /* 29 */ this.isExtractionSupported = isExtractionSupported;
        /* 30 */ this.isVerificationSupported = isVerificationSupported;
        /* 31 */ this.isIdentificationSupported = isIdentificationSupported;
        /* 32 */ this.isConversionToSupported = isConversionToSupported;
        /* 33 */ this.isConversionFromSupported = isConversionFromSupported;
        /* 34 */ this.maxTemplateSize = maxTemplateSize;
    }

    public NBBiometricsTemplateTypeInfo(NBBiometricsTemplateTypeInfoData data) {
        /* 38 */ this(NBBiometricsTemplateType.get(data.eTemplateType), data.bIsExtractionSupported,
                data.bIsVerificationSupported, data.bIsIdentificationSupported, data.bIsConversionToSupported,
                data.bIsConversionFromSupported, data.stMaxTemplateSize/* 39 */ .intValue());
    }

    public final NBBiometricsTemplateType getTemplateType() {
        /* 52 */ return this.templateType;
    }

    public final boolean getIsExtractionSupported() {
        /* 61 */ return this.isExtractionSupported;
    }

    public final boolean getIsVerificationSupported() {
        /* 70 */ return this.isVerificationSupported;
    }

    public final boolean getIsIdentificationSupported() {
        /* 79 */ return this.isIdentificationSupported;
    }

    public final boolean getIsConversionToSupported() {
        /* 88 */ return this.isConversionToSupported;
    }

    public final boolean getIsConversionFromSupported() {
        /* 97 */ return this.isConversionFromSupported;
    }

    public final int getMaxTemplateSize() {
        /* 106 */ return this.maxTemplateSize;
    }

    public String toString() {
        /* 115 */ return String.format("%s", new Object[] { getTemplateType() });
    }

    public boolean equals(Object o) {
        /* 120 */ if (o == this)
            return true;
        /* 121 */ if (!(o instanceof NBBiometricsTemplateTypeInfo)) {
            /* 122 */ return false;
        }
        /* 124 */ NBBiometricsTemplateTypeInfo templateTypeInfo = (NBBiometricsTemplateTypeInfo) o;
        /* 125 */ return templateTypeInfo.templateType.equals(this.templateType);
    }

    public int hashCode() {
        /* 130 */ return this.templateType.hashCode();
    }
}
