package com.nextbiometrics.biometrics.event;

import com.nextbiometrics.biometrics.NBBiometricsContext;
import com.nextbiometrics.biometrics.NBBiometricsStatus;
import com.nextbiometrics.devices.NBDevice;
import com.nextbiometrics.devices.NBDeviceScanFormatInfo;
import com.nextbiometrics.devices.NBDeviceScanStatus;
import java.util.EventObject;

public final class NBBiometricsScanPreviewEvent extends EventObject {
    private static final long serialVersionUID = -7267020593568273910L;
    private NBBiometricsContext biometricsContext;
    private NBBiometricsStatus biometricsStatus;
    private NBDevice device;
    private NBDeviceScanStatus scanStatus;
    private NBDeviceScanFormatInfo format;
    private byte[] image;
    private int fingerDetectValue;

    public NBBiometricsScanPreviewEvent(NBBiometricsContext biometricsContext, NBBiometricsStatus biometricsStatus,
            NBDevice device, NBDeviceScanStatus scanStatus, NBDeviceScanFormatInfo format, byte[] image,
            int fingerDetectValue) {
        super(biometricsContext);
        this.biometricsContext = biometricsContext;
        this.biometricsStatus = biometricsStatus;
        this.device = device;
        this.scanStatus = scanStatus;
        this.format = format;
        this.image = image;
        this.fingerDetectValue = fingerDetectValue;
    }

    public NBBiometricsContext getBiometricsContext() {
        return this.biometricsContext;
    }

    public NBBiometricsStatus getBiometricsStatus() {
        return this.biometricsStatus;
    }

    public NBDevice getDevice() {
        return this.device;
    }

    public NBDeviceScanStatus getScanStatus() {
        return this.scanStatus;
    }

    public void setScanStatus(NBDeviceScanStatus status) {
        this.scanStatus = status;
    }

    public NBDeviceScanFormatInfo getFormat() {
        return this.format;
    }

    public byte[] getImage() {
        return this.image;
    }

    public int getFingerDetectValue() {
        return this.fingerDetectValue;
    }
}
