package com.nextbiometrics.biometrics.jna;

import com.nextbiometrics.system.jna.NBVersionData;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Structure.ByReference;
import java.util.Arrays;
import java.util.List;

public class NBBiometricsAlgorithmInfoData extends Structure {
    public int uiId;
    public NBVersionData sVersion;

    public NBBiometricsAlgorithmInfoData() {
    }

    public NBBiometricsAlgorithmInfoData(Pointer p) {
        super(p);
        read();
    }

    protected List<String> getFieldOrder() {
        return Arrays.asList(new String[] { "uiId", "sVersion" });
    }

    public static class ByReference extends NBBiometricsAlgorithmInfoData implements Structure.ByReference {
        public ByReference() {
            this(null);
        }

        public ByReference(NBBiometricsAlgorithmInfoData value) {
            if (value != null) {
                this.uiId = value.uiId;
                this.sVersion = value.sVersion;
            }
        }
    }
}
