package com.nextbiometrics.biometrics.jna;

import com.nextbiometrics.system.jna.NBSizeType;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Structure.ByReference;
import java.util.Arrays;
import java.util.List;

public class NBBiometricsTemplateTypeInfoData extends Structure {
    public int eTemplateType;
    public boolean bIsExtractionSupported;
    public boolean bIsVerificationSupported;
    public boolean bIsIdentificationSupported;
    public boolean bIsConversionToSupported;
    public boolean bIsConversionFromSupported;
    public NBSizeType stMaxTemplateSize;

    public NBBiometricsTemplateTypeInfoData() {
    }

    public NBBiometricsTemplateTypeInfoData(Pointer p) {
        /* 43 */ super(p);
        /* 44 */ read();
    }

    protected List<String> getFieldOrder() {
        /* 49 */ return Arrays.asList(new String[] { "eTemplateType", "bIsExtractionSupported",
                "bIsVerificationSupported", "bIsIdentificationSupported", "bIsConversionToSupported",
                "bIsConversionFromSupported", "stMaxTemplateSize" });
    }

    public static class ByReference extends NBBiometricsTemplateTypeInfoData implements Structure.ByReference {
        public ByReference() {
            /* 13 */ this(null);
        }

        public ByReference(NBBiometricsTemplateTypeInfoData value) {
            /* 18 */ if (value != null) {
                /* 19 */ this.eTemplateType = value.eTemplateType;
                /* 20 */ this.bIsExtractionSupported = value.bIsExtractionSupported;
                /* 21 */ this.bIsVerificationSupported = value.bIsVerificationSupported;
                /* 22 */ this.bIsIdentificationSupported = value.bIsIdentificationSupported;
                /* 23 */ this.bIsConversionToSupported = value.bIsConversionToSupported;
                /* 24 */ this.bIsConversionFromSupported = value.bIsConversionFromSupported;
                /* 25 */ this.stMaxTemplateSize = value.stMaxTemplateSize;
            }
        }
    }
}
