package com.nextbiometrics.devices;

import java.util.EnumSet;

public enum NBDeviceScanFormatType {
    /* 12 */ NATIVE(0),

    /* 16 */ UPSCALED(1),

    /* 20 */ DOWNSCALED(2),

    /* 24 */ OPTICAL_EQUIVALENT(3);

    private int value;

    private NBDeviceScanFormatType(int value) {
        /* 37 */ this.value = value;
    }

    public static final NBDeviceScanFormatType get(int value) {
        /* 45 */ for (NBDeviceScanFormatType v : EnumSet.allOf(NBDeviceScanFormatType.class)) {
            /* 46 */ if (value == v.getValue())
                /* 47 */ return v;
        }
        /* 49 */ throw new IllegalArgumentException("value is an unknown NBDeviceScanFormatType value");
    }

    public final int getValue() {
        /* 57 */ return this.value;
    }
}
