package com.nextbiometrics.devices.event;

import com.nextbiometrics.devices.NBDevice;
import com.nextbiometrics.devices.NBDeviceScanFormatInfo;
import com.nextbiometrics.devices.NBDeviceScanStatus;
import java.util.EventObject;

public final class NBDeviceScanPreviewEvent extends EventObject {
    private static final long serialVersionUID = -7267020593568273910L;
    private NBDevice device;
    private NBDeviceScanStatus status;
    private NBDeviceScanFormatInfo format;
    private byte[] image;
    private int fingerDetectValue;

    public NBDeviceScanPreviewEvent(NBDevice device, NBDeviceScanStatus status, NBDeviceScanFormatInfo format,
            byte[] image, int fingerDetectValue) {
        /* 31 */ super(device);
        /* 32 */ this.device = device;
        /* 33 */ this.status = status;
        /* 34 */ this.format = format;
        /* 35 */ this.image = image;
        /* 36 */ this.fingerDetectValue = fingerDetectValue;
    }

    public NBDevice getDevice() {
        /* 49 */ return this.device;
    }

    public NBDeviceScanStatus getStatus() {
        /* 58 */ return this.status;
    }

    public void setStatus(NBDeviceScanStatus status) {
        /* 67 */ this.status = status;
    }

    public NBDeviceScanFormatInfo getFormat() {
        /* 76 */ return this.format;
    }

    public byte[] getImage() {
        /* 85 */ return this.image;
    }

    public int getFingerDetectValue() {
        /* 94 */ return this.fingerDetectValue;
    }
}
