package com.nextbiometrics.system;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.win32.W32APIOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class NBSystemLibrary {
    static final NativeLibrary NATIVE_LIBRARY;
    public static final Map<String, Object> API_OPTIONS;

    static {
        try {
            Map apiOptions = new HashMap();
            apiOptions.putAll(W32APIOptions.ASCII_OPTIONS);
            if ((Platform.isWindows()) && (!Platform.is64Bit())) {
                apiOptions.put("calling-convention", Integer.valueOf(63));
            }
            API_OPTIONS = Collections.unmodifiableMap(apiOptions);
            NATIVE_LIBRARY = NativeLibrary.getInstance("NBBiometrics", API_OPTIONS);
            Native.register(NBSystemLibrary.class, NATIVE_LIBRARY);
        } catch (Throwable e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}
